/*
 * Copyright (c) 2001 Jilles van Gurp
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package newstate;

/**
* The FSM uses the command pattern to implement actions. All actions must 
* implement this interface.
*/
public interface FSMAction extends java.io.Serializable
{
        /**
        * @param fsmc This is the context in which the command is executed. The
        * context can be used as a repository for objects. That is because
        * FSMContext extends from java.util.Hashtable. 
        * @param data Some extra data that can be given to a command
        */
        public void execute(FSMContext fsmc, Object data);
}
