/*
 * Copyright (c) 2001 Jilles van Gurp
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package newstate;

/**
* Transitions are created on the fly and should not be created manually.
*/
class Transition implements java.io.Serializable
{
        State target;
        State source;
        
        FSMAction action;
        
        public Transition(State s, State t, FSMAction a)
        {
                source = s;
                target = t;
                action = a;
        }
                
        public void execute(FSMContext fsmc, Object data)
        {
                // trigger a state exit event in the old state
                // execute the action
                source.getStateExitAction().execute(fsmc, data);
                if(action != null)
                        action.execute(fsmc, data);
                fsmc.setState(target);
                target.getStateEntryAction().execute(fsmc, data);
        }
}
