/*
 * Copyright (c) 2001 Jilles van Gurp
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package newstate.tools;

import java.io.*;
import newstate.*;

public class Serializer
{
        public static void serialize(Object o, String filename)
        {
                try
                {
                        FileOutputStream ostream = new FileOutputStream(filename);
                        ObjectOutputStream objstr = new ObjectOutputStream(ostream);
                        objstr.writeObject(o);
                        ostream.close();
                } 
                catch (Exception e) 
                {
                        e.printStackTrace();
                }
        }
        
        public static Object deserialize(String filename)
        {
                try
                {
                        FileInputStream istream = new FileInputStream(filename);
                        ObjectInputStream objstr = new ObjectInputStream(istream);
                        Object o = objstr.readObject();
                        istream.close();
                        return o;
                } 
                catch (Exception e) 
                {
                        e.printStackTrace();
                }
                return null;            
        }
        
/*        public static void main(String ps[])
        {
                PrintAction p = new PrintAction("Hello world!");
                
                serialize(p,"HelloWorldAction.ser");
                FSMAction f = (FSMAction)deserialize("HelloWorldAction.ser");
                f.execute(null,null);                
        }*/
}
