/*
 * Copyright (c) 2001 Jilles van Gurp
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package wrapatext.newstatepattern;

import wrapatext.*;
import newstate.*;
import newstate.tools.*;
import newstate.tools.actions.*;

public class WrapATextFSM implements WrapAText
{
        FSM fsm;
        FSMContext c;
        
        public WrapATextFSM()
        {                
                FSMAction fullEntry = new FullEntry();
                FSMAction collectEntry = new CollectEntry();
                FSMAction init = new Init();
                FSMAction processChar = new ProcessChar();
                FSMAction skip = new Skip();
                FSMAction reset = new Reset();
                
                Serializer.serialize(fullEntry,"fullEntry.ser");
                Serializer.serialize(collectEntry,"collectEntry.ser");
                Serializer.serialize(init,"initAction.ser");
                Serializer.serialize(processChar,"processChar.ser");
                Serializer.serialize(skip,"skip.ser");
                Serializer.serialize(reset,"reset.ser");                
                
                fsm = FSMGenerator.generateFSM("WrapAText.xml");
                c = fsm.createFSMInstance();
        }
        
        public void feedChar(char character)
        {
                c.dispatch("feedChar", new Character(character));
        }
}
