/*
 * Copyright (c) 2001 Jilles van Gurp
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package wrapatext.statepattern;

import wrapatext.*;

public class CollectState extends State
{
        public void feedChar(Context con, Character c)
        {
                processChar(con, c);
        }
        
        public void EOF(Context c)
        {
                c.setState(c.full);
                c.current.release(c);
        }
        
        public void release(Context c)
        {
                throw new Error("Message illegal for this state");
        }
}
