/*
 * Copyright (c) 2001 Jilles van Gurp
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package wrapatext.statepattern;

import wrapatext.*;

public class Context
{
        public State current = null;
        
        State empty = new EmptyState();
        State collect = new CollectState();
        State full = new FullState();
        
        Counter counter = new Counter();
        StringBuffer line = new StringBuffer(80);
        
        public Context()
        {
                current=empty;
        }
        
        public void setState(State s)
        {
                current = s;
        }        
}
