/*
 * Copyright (c) 2001 Jilles van Gurp
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package wrapatext.statepattern;

import wrapatext.*;

public abstract class State
{
        public abstract void feedChar(Context con, Character c);
        public abstract void EOF(Context c);
        public abstract void release(Context c);        
        
        public void processChar(Context con, Character c)
        {
                con.counter.increment();
                con.line.append("" + c);
                con.setState(con.collect);
                if(con.counter.getValue() > 78 || c.charValue() == '\n')
                {
                        con.current.EOF(con);
                }
                WasteCyckles.wasteIt(100);
        }
}
