/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.Child;
import com.ibm.xml.parser.Parent;
import com.ibm.xml.parser.TXDOMException;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.Visitor;
import org.w3c.dom.DOMException;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;

public class GeneralReference
extends Parent
implements EntityReference {
    private String name;

    public GeneralReference(String string) {
        this.name = string;
    }

    public Object clone() {
        return this.cloneNode(true);
    }

    public synchronized Node cloneNode(boolean bl) {
        this.checkFactory();
        GeneralReference generalReference = (GeneralReference)this.factory.createEntityReference(this.getName());
        if (bl) {
            generalReference.children.ensureCapacity(this.children.getLength());
            int n = 0;
            while (n < this.children.getLength()) {
                generalReference.appendChild(this.children.item(n).cloneNode(true));
                ++n;
            }
        }
        return generalReference;
    }

    public synchronized boolean equals(Node node, boolean bl) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof GeneralReference)) {
            return false;
        }
        GeneralReference generalReference = (GeneralReference)node;
        if (!generalReference.getName().equals(this.getName())) {
            return false;
        }
        return !bl || generalReference.children.equals(this.children, bl);
    }

    public short getNodeType() {
        return 5;
    }

    public String getNodeName() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getLanguage() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof TXElement) {
            return ((TXElement)this.parent).getLanguage();
        }
        if (this.parent instanceof GeneralReference) {
            return ((GeneralReference)this.parent).getLanguage();
        }
        return null;
    }

    public void acceptPre(Visitor visitor) throws Exception {
        visitor.visitGeneralReferencePre(this);
    }

    public void acceptPost(Visitor visitor) throws Exception {
        visitor.visitGeneralReferencePost(this);
    }

    protected void checkChildType(Node node) throws DOMException {
        switch (node.getNodeType()) {
            default: {
                throw new TXDOMException(3, "Specified node type (" + node.getNodeType() + ") can't be a child of EntityReference.");
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 23: 
        }
    }

    public void collectNamespaceAttributes() {
        this.collectNamespaceAttributes(this.getParentNode());
    }

    public void collectNamespaceAttributes(Node node) {
        if (!this.getFactory().isProcessNamespace()) {
            return;
        }
        Node node2 = this.getFirstWithoutReference();
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                ((TXElement)node2).collectNamespaceAttributes(node);
            }
            node2 = ((Child)node2).getNextWithoutReference();
        }
    }

    public void removeOverlappedNamespaceAttributes() {
        if (!this.getFactory().isProcessNamespace()) {
            return;
        }
        Node node = this.getFirstWithoutReference();
        while (node != null) {
            if (node.getNodeType() == 1) {
                ((TXElement)node).removeOverlappedNamespaceAttributes();
            }
            node = ((Child)node).getNextWithoutReference();
        }
    }
}

